<?php 
    include "../../conn.php";
    include "../../functions2.php";
    
    header('Content-Type: application/json; charset=utf-8');
    header('Strict-Transport-Security: max-age=31536000');
    header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
    header('Access-Control-Allow-Credentials: true');
    $origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
    header('Access-Control-Allow-Origin: ' . $origin);
    header('vary: Origin');
    
    date_default_timezone_set("Asia/Kolkata");
    $shnunc = date("Y-m-d H:i:s");
    $res = [
        'code' => 11,
        'msg' => 'Method not allowed',
        'msgCode' => 12,
        'serviceNowTime' => $shnunc,
    ];
    $shonubody = file_get_contents("php://input");
    $shonupost = json_decode($shonubody, true);
    
    if ($_SERVER['REQUEST_METHOD'] != 'GET') {
        if (isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['signature']) && isset($shonupost['timestamp'])) {
            $language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
            $random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
            $signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
            $shonustr = '{"language":'.$language.',"random":"'.$random.'"}';
            $shonusign = strtoupper(md5($shonustr));
            if($shonusign == $signature){
                $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
                $author = $bearer[1];				
                $is_jwt_valid = is_jwt_valid($author);
                $data_auth = json_decode($is_jwt_valid, 1);
                if($data_auth['status'] === 'Success') {
                    $sesquery = "SELECT codechorkamukala FROM shonu_subjects WHERE akshinak = '$author'";
                    $sesresult = $conn->query($sesquery);
                    
                    $sesnum = mysqli_num_rows($sesresult);
                   
if ($sesresult->num_rows == 1) {
    $user = $sesresult->fetch_assoc();
    $userCode = $user['codechorkamukala']; // Fetch userCode from codechorkamukala column

    // Fetch balance from API vendor
    $apiResponse = fetchVendorBalance($userCode);


                        if ($apiResponse !== null) {
                            $apiData = json_decode($apiResponse, true);
                            if (isset($apiData['success']) && $apiData['success'] && isset($apiData['message'])) {
                                $tbChessBalance = (float)$apiData['message'];
                            } else {
                                $tbChessBalance = 0; // Default to 0 if API response is invalid
                            }
                        } else {
                            $tbChessBalance = 0; // Default to 0 if API call fails
                        }

                        $balquery = "SELECT motta
                        FROM shonu_kaichila
                        WHERE balakedara = ".$data_auth['payload']['id'];
                        $userId = $data_auth['payload']['id'];
                      $balresult = $conn->query($balquery);
                      $balarr = mysqli_fetch_array($balresult);
                      $data['thidGameBalanceList'][0]['vendorCode'] = 'Lottery';
                      $data['thidGameBalanceList'][0]['balance'] = (int)$balarr['motta'];
                        $data['thidGameBalanceList'][1]['vendorCode'] = 'TB_Chess';
                        $data['thidGameBalanceList'][1]['balance'] = $tbChessBalance;
                        $data['thidGameBalanceList'][2]['vendorCode'] = 'Wickets9';
                        $data['thidGameBalanceList'][2]['balance'] = 0;
                        $data['thidGameBalanceList'][3]['vendorCode'] = 'CQ9';
                        $data['thidGameBalanceList'][3]['balance'] = 0;
                        $data['thidGameBalanceList'][4]['vendorCode'] = 'MG';
                        $data['thidGameBalanceList'][4]['balance'] = 0;
                        $data['thidGameBalanceList'][5]['vendorCode'] = 'JDB';
                        $data['thidGameBalanceList'][5]['balance'] = 0;
                        $data['thidGameBalanceList'][6]['vendorCode'] = 'DG';
                        $data['thidGameBalanceList'][6]['balance'] = 0;
                        $data['thidGameBalanceList'][7]['vendorCode'] = 'CMD';
                        $data['thidGameBalanceList'][7]['balance'] = 0;
                        $data['thidGameBalanceList'][8]['vendorCode'] = 'SaBa';
                        $data['thidGameBalanceList'][8]['balance'] = 0;
                        $data['thidGameBalanceList'][9]['vendorCode'] = 'EVO_Video';
                        $data['thidGameBalanceList'][9]['balance'] = 0;
                        $data['thidGameBalanceList'][10]['vendorCode'] = 'JILI';
                        $data['thidGameBalanceList'][10]['balance'] = 0;
                        $data['thidGameBalanceList'][11]['vendorCode'] = 'Card365';
                        $data['thidGameBalanceList'][11]['balance'] = 0;
                        $data['thidGameBalanceList'][12]['vendorCode'] = 'V8Card';
                        $data['thidGameBalanceList'][12]['balance'] = 0;
                        $data['thidGameBalanceList'][13]['vendorCode'] = 'AG_Video';
                        $data['thidGameBalanceList'][13]['balance'] = 0;
                        $data['thidGameBalanceList'][14]['vendorCode'] = 'PG';
                        $data['thidGameBalanceList'][14]['balance'] = 0;
                        $data['thidGameBalanceList'][15]['vendorCode'] = 'TB';
                        $data['thidGameBalanceList'][15]['balance'] = 0;
                        $data['thidGameBalanceList'][16]['vendorCode'] = 'WM_Video';
                        $data['thidGameBalanceList'][16]['balance'] = 0;
                       
$withdrawSumQuery = "SELECT SUM(motta) as totalWithdraw FROM hintegedukolli WHERE balakedara = $userId AND sthiti = 1";
$withdrawSumResult = $conn->query($withdrawSumQuery);
$withdrawSumRow = $withdrawSumResult ? $withdrawSumResult->fetch_assoc() : ['totalWithdraw' => 0];
$data['totalWithdraw'] = isset($withdrawSumRow['totalWithdraw']) && $withdrawSumRow['totalWithdraw'] !== null ? (int)$withdrawSumRow['totalWithdraw'] : 0;


                       $rechargeSumQuery = "SELECT SUM(motta) as totalRecharge FROM thevani WHERE balakedara = $userId AND sthiti = 1";
$rechargeSumResult = $conn->query($rechargeSumQuery);
$rechargeSumRow = $rechargeSumResult ? $rechargeSumResult->fetch_assoc() : ['totalRecharge' => 0];
$data['totalRecharge'] = isset($rechargeSumRow['totalRecharge']) && $rechargeSumRow['totalRecharge'] !== null ? (int)$rechargeSumRow['totalRecharge'] : 0;

                        
                        $res['data'] = $data;
                        $res['code'] = 0;
                        $res['msg'] = 'Succeed';
                        $res['msgCode'] = 0;
                        http_response_code(200);
                        echo json_encode($res);					
                    }
                    else{
                        $res['code'] = 4;
                        $res['msg'] = 'No operation permission';
                        $res['msgCode'] = 2;
                        http_response_code(401);
                        echo json_encode($res);
                    }					
                }
                else{					
                    $res['code'] = 4;
                    $res['msg'] = 'No operation permission';
                    $res['msgCode'] = 2;
                    http_response_code(401);
                    echo json_encode($res);					
                }
            }
            else{
                $res['code'] = 5;
                $res['msg'] = 'Wrong signature';
                $res['msgCode'] = 3;
                http_response_code(200);
                echo json_encode($res);				
            }
        }
        else{
            $res['code'] = 7;
            $res['msg'] = 'Param is Invalid';
            $res['msgCode'] = 6;
            http_response_code(200);
            echo json_encode($res);			
        }		
    } else {		
        http_response_code(405);
        echo json_encode($res);
    }

    /**
     * Fetch user balance from the API vendor.
     *
     * @param string $userCode
     * @return string|null
     */
    function fetchVendorBalance($userCode)
    {
        try {
            $authToken = getAuthToken();
            $apiUrl = "https://dcyqv8f2id.com/api/v2/user/balance"; // Replace with actual API URL

            $postData = [
                'userCode' => $userCode
            ];

            $ch = curl_init($apiUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Authorization: Bearer ' . $authToken,
                'Content-Type: application/json'
            ]);
            curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if ($httpCode == 200) {
                return $response; // Return the raw response
            }
        } catch (Exception $e) {
            error_log('Error fetching vendor balance: ' . $e->getMessage());
        }

        return null;
    }

    /**
     * Fetch authentication token.
     *
     * @return string
     */
    function getAuthToken()
    {
        try {
            $authUrl = "https://dcyqv8f2id.com/api/v2/auth/createtoken"; // Replace with actual auth URL
            $postData = [
                'clientId' => 'top52-inr5',
                'clientSecret' => 'V1Umxk4UTEbKO3ZNJSt9bUAcw4LLKg1a'
            ];

        	$ch = curl_init($authUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Accept: application/json'
            ]);
            curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if ($httpCode == 200) {
                $data = json_decode($response, true);
                if (isset($data['token'])) {
                    return $data['token'];
                }
            }
        } catch (Exception $e) {
            error_log('Error fetching auth token: ' . $e->getMessage());
        }

        throw new Exception('Failed to fetch auth token');
    }
?>